# * Copyright (C) 2020 Texas Instruments Incorporated - http://www.ti.com/
#  *
#  *
#  *  Redistribution and use in source and binary forms, with or without
#  *  modification, are permitted provided that the following conditions
#  *  are met:
#  *
#  *    Redistributions of source code must retain the above copyright
#  *    notice, this list of conditions and the following disclaimer.
#  *
#  *    Redistributions in binary form must reproduce the above copyright
#  *    notice, this list of conditions and the following disclaimer in the
#  *    documentation and/or other materials provided with the
#  *    distribution.
#  *
#  *    Neither the name of Texas Instruments Incorporated nor the names of
#  *    its contributors may be used to endorse or promote products derived
#  *    from this software without specific prior written permission.
#  *
#  *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#  *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#  *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#  *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#  *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#  *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#  *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#  *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#  *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#  *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#  *
# */


from Program_Callbacks import *
from Output_Info import *


def input_settings(self, startup):
    if startup:
        # Frame for the application choice
        self.fr = tk.Frame(self)
        if sys.platform.startswith('darwin'):
            self.fr.grid(row=0, column=0, rowspan=3, sticky='w', padx=5, pady=5)
            self.fr.config(height=105, width=175, bd=5, highlightbackground="black", highlightthickness=1, bg='white')
            self.fr.grid_propagate(0)
        else:
            self.fr.grid(row=0, column=0, rowspan=4, sticky='w', padx=5, pady=5)
            self.fr.config(height=138, width=175, bd=5, highlightbackground="black", highlightthickness=1, bg='white')

        # Label for the applications frame
        if sys.platform.startswith('darwin'):
            self.w = Label(self.fr, text='Applications:', font='systemSmallEmphasizedSystemFont', background='white')
        else:
            self.w = Label(self.fr, text='Applications:', font='Helvetica 10 bold', background='white')
        self.w.grid(row=0, column=0, padx=5, pady=5)

        # Vars variable for the radio button options
        self.v = tk.IntVar()
        self.v.set(0)

        # Radio Buttons for the application choice
        self.radio1 = tk.Radiobutton(self.fr, background='white', text='Read from existing ZC', variable=self.v, value=1,
                                     command=lambda: feature_action(self))
        self.radio1.grid(row=1, column=0, sticky='w', padx=5)

        self.radio2 = tk.Radiobutton(self.fr, background='white', text='Write to new ZC', variable=self.v, value=2,
                                     command=lambda: feature_action(self))
        self.radio2.grid(row=2, column=0, sticky='w', padx=5)

        self.radio3 = tk.Radiobutton(self.fr, background='white', text='Clone Content', variable=self.v, value=3,
                                     command=lambda: feature_action(self))
        self.radio3.grid(row=3, column=0, sticky='w', padx=5)

        if sys.platform.startswith('darwin'):
            self.radio1.config(font='systemSmallSystemFont')
            self.radio2.config(font='systemSmallSystemFont')
            self.radio3.config(font='systemSmallSystemFont')
        else:
            self.radio1.config(font='Helvetica 10')
            self.radio2.config(font='Helvetica 10')
            self.radio3.config(font='Helvetica 10')

        # COM Ports Frame
        self.fr_ports = tk.Frame(self)
        if sys.platform.startswith('darwin'):
            self.fr_ports.grid(row=3, column=0, rowspan=8, sticky='w', padx=5, pady=5)
            self.fr_ports.config(background='white', height=250, width=175, bd=5, highlightbackground="black",
                                 highlightthickness=1)
            self.fr_ports.grid_propagate(0)
        else:
            self.fr_ports.grid(row=4, column=0, rowspan=8, sticky='w', padx=5, pady=5)
            self.fr_ports.config(background='white', height=60, width=88, bd=5, highlightbackground="black",
                                 highlightthickness=1)

        # Label for READ COM Port
        read_label = Label(self.fr_ports, text='Read Port', background='white')
        read_label.grid(row=5, column=0, padx=5, pady=5)

        # Label for WRITE COM Port
        write_label = Label(self.fr_ports, text='Write Port', background='white')
        write_label.grid(row=10, column=0, padx=5, pady=5)

        if sys.platform.startswith('darwin'):
            read_label.config(font='systemSmallEmphasizedSystemFont')
            write_label.config(font='systemSmallEmphasizedSystemFont')
        else:
            read_label.config(font='Helvetica 10 bold')
            write_label.config(font='Helvetica 10 bold')

        # Canvas for Read COM Port
        self.canvas_read_port = tk.Canvas(self.fr_ports, bg='white', highlightbackground="white")
        self.canvas_read_port.grid(row=6, column=0, rowspan=3, padx=5, pady=5, sticky='w')
        self.canvas_read_port.config(width=130, height=64, highlightthickness=0)
        self.canvas_read_port.config(scrollregion=(0, 0, 1000, 1000))
        self.canvas_read_port.grid_propagate(0)

        # Canvas for Write COM Port
        self.canvas_write_port = tk.Canvas(self.fr_ports, bg='white', highlightbackground="white")
        self.canvas_write_port.grid(row=11, column=0, rowspan=3, padx=5, pady=5, sticky='w')
        self.canvas_write_port.config(width=130, height=64, highlightthickness=0)
        self.canvas_write_port.config(scrollregion=(0, 0, 1000, 1000))
        self.canvas_write_port.grid_propagate(0)

        # Frame for the READ Port
        self.fr_port_read = tk.Frame(self.canvas_read_port)
        self.fr_port_read.grid(row=6, column=0, rowspan=3)
        self.fr_port_read.config(width=40, height=50)
        self.fr_port_read.config(bg='white', highlightthickness=0, highlightbackground='white')
        self.canvas_read_port.create_window(1, 0, window=self.fr_port_read, anchor='nw')

        # Frame for the WRITE Port
        self.fr_port_write = tk.Frame(self.canvas_write_port)
        self.fr_port_write.grid(row=11, column=0, rowspan=3)
        self.fr_port_write.config(width=40, height=50, highlightthickness=0, highlightbackground='white')
        self.fr_port_write.config(bg='white')
        self.canvas_write_port.create_window(1, 0, window=self.fr_port_write, anchor='nw')

        # Scrollbar for READ COM Port Listbox
        self.my_scrollbar_port_read = tk.Scrollbar(self.fr_ports, orient='vertical')
        self.my_scrollbar_port_read.grid(row=6, column=1, padx=5, pady=5, sticky='ns', rowspan=3)
        self.canvas_read_port.config(yscrollcommand=self.my_scrollbar_port_read.set)
        self.my_scrollbar_port_read.config(command=self.canvas_read_port.yview)

        # Create Scrollbar for WRITE COM Port Listbox
        self.my_scrollbar_port_write = tk.Scrollbar(self.fr_ports, orient='vertical')
        self.my_scrollbar_port_write.grid(row=11, column=1, padx=5, pady=5, sticky='ns', rowspan=3)
        self.canvas_write_port.config(yscrollcommand=self.my_scrollbar_port_write.set)
        self.my_scrollbar_port_write.config(command=self.canvas_write_port.yview)

        # READ COM Port List Box
        self.Lb1 = tk.Listbox(self.fr_port_read, selectmode=tk.SINGLE, exportselection=False, highlightbackground="white")
        self.Lb1.config(height=50, width=30, bd=0, highlightthickness=0, activestyle='none', highlightbackground='white')
        self.Lb1.grid(row=6, column=0,  rowspan=3, sticky='s')
        self.Lb1.grid_propagate(0)

        # WRITE COM Port List Box
        self.Lb2 = tk.Listbox(self.fr_port_write, selectmode=tk.SINGLE, exportselection=False, highlightbackground="white")
        self.Lb2.config(height=50, width=30, bd=0, highlightthickness=0, activestyle='none', highlightbackground='white')
        self.Lb2.grid(row=11, column=0, rowspan=3, sticky='s')
        self.Lb2.grid_propagate(0)

        if sys.platform.startswith('darwin'):
            self.Lb1.config(font='systemSmallSystemFont')
            self.Lb2.config(font='systemSmallSystemFont')

        # Fill Port Selections
        ports = serial_ports()
        for x in range(len(ports)):
            self.Lb1.insert(END, ports[x])
            self.Lb2.insert(END, ports[x])

        # Disable the List Boxes
        self.Lb1.config(state=tk.DISABLED)
        self.Lb2.config(state=tk.DISABLED)
    else:
        # Clear application choice
        self.v.set(0)
        # Clear Port Options
        self.Lb1.selection_clear(0, END)
        self.Lb2.selection_clear(0, END)
        # Disable the List Boxes
        self.Lb1.config(state=tk.DISABLED)
        self.Lb2.config(state=tk.DISABLED)
    return
